#include <stdio.h>
#include <string.h>

typedef struct {
	char ime[30];
	char prezime[30];
	char pozicija[3];
	float visina;
} kosarkas;

int UcitajKosarkase (char ulazniFajl[], kosarkas kosarkasi[]) {
	int i = 0;
	
	FILE *f = fopen(ulazniFajl, "r");
	
	while (!feof(f)) {
		fscanf(f, "%s %s %s %f", kosarkasi[i].ime, kosarkasi[i].prezime, kosarkasi[i].pozicija, &kosarkasi[i].visina);
		i++;
	}
	
	fclose(f);
	
	return i;
}

void IspisKosarkasa (char izlazniFajl[], kosarkas kosarkasi[], int n) {
	int i;
	
	FILE *f = fopen(izlazniFajl, "w");
	
	for (i = 0; i < n; i++) 
		fprintf(f, "%s %s (%s) - %.2f\n", kosarkasi[i].ime, kosarkasi[i].prezime, kosarkasi[i].pozicija, kosarkasi[i].visina);
		
	fclose(f);
}

int IzdvojIgraceIstePozicije (char pozicija[], kosarkas kosarkasi[], int n, kosarkas odgovarajuci[]) {
	int i, k = 0;
	
	for (i = 0; i < n; i++) {
		if (strcmp(kosarkasi[i].pozicija, pozicija) == 0) {
			odgovarajuci[k] = kosarkasi[i];
			k++;
		}
	}
	
	return k;
}

void SortirajPoVisini (kosarkas kosarkasi[], int n) {
	int i, j;
	kosarkas t;
	
	for (i = 0; i < n - 1; i++) 
		for (j = i + 1; j < n; j++) 
			if (kosarkasi[i].visina < kosarkasi[j].visina) {
				t = kosarkasi[i];
				kosarkasi[i] = kosarkasi[j];
				kosarkasi[j] = t;	
			}
}

main () {
	int n, m;
	kosarkas kosarkasi[20], odgovarajuci[20];
	char ulazniFajl[20], izlazniFajl[20], pozicija[3];
	
	scanf("%s", ulazniFajl);
	scanf("%s", izlazniFajl);
	scanf("%s", pozicija);
	
	n = UcitajKosarkase(ulazniFajl, kosarkasi);
	m = IzdvojIgraceIstePozicije(pozicija, kosarkasi, n, odgovarajuci);
	SortirajPoVisini(odgovarajuci, m);
	IspisKosarkasa(izlazniFajl, odgovarajuci, m);
}
